@echo off
REM Install Dependencies for RapidSurf (Windows)
REM This script installs all required dependencies

setlocal enabledelayedexpansion

echo ==========================================
echo RapidSurf Dependency Installer (Windows)
echo ==========================================
echo.
echo This script will install:
echo   - Python 3.12+ (if not present)
echo   - Visual C++ Redistributable
echo   - Python packages (PySide6, VTK, numpy, etc.)
echo.
echo Press Ctrl+C to cancel, or
pause

REM Get script directory
set SCRIPT_DIR=%~dp0
cd /d "%SCRIPT_DIR%"

REM ========================================
REM Check Administrator Rights
REM ========================================
echo.
echo Checking administrator rights...
net session >nul 2>&1
if %errorLevel% neq 0 (
    echo.
    echo WARNING: Not running as Administrator!
    echo Some installations may fail without admin rights.
    echo.
    echo Please right-click this script and select "Run as Administrator"
    echo.
    pause
)

REM ========================================
REM Check Python Installation
REM ========================================
echo.
echo [1/4] Checking Python Installation...
echo ==========================================

python --version >nul 2>&1
if errorlevel 1 (
    echo Python not found!
    echo.
    echo Please install Python 3.12 or later from:
    echo https://www.python.org/downloads/
    echo.
    echo IMPORTANT: Check "Add Python to PATH" during installation!
    echo.
    start https://www.python.org/downloads/
    echo.
    echo After installing Python, run this script again.
    pause
    exit /b 1
)

for /f "tokens=2" %%i in ('python --version 2^>^&1') do set PYTHON_VERSION=%%i
echo ✓ Python %PYTHON_VERSION% found

REM ========================================
REM Check Visual C++ Redistributable
REM ========================================
echo.
echo [2/4] Checking Visual C++ Redistributable...
echo ==========================================

REM Check if VC Redist is installed by looking for vcruntime140.dll
where vcruntime140.dll >nul 2>&1
if errorlevel 1 (
    echo Visual C++ Redistributable not found!
    echo.
    echo Downloading installer...
    powershell -command "Invoke-WebRequest -Uri 'https://aka.ms/vs/17/release/vc_redist.x64.exe' -OutFile 'vc_redist_x64.exe'"

    if exist "vc_redist_x64.exe" (
        echo Running installer...
        start /wait vc_redist_x64.exe /install /quiet /norestart
        del vc_redist_x64.exe
        echo ✓ Visual C++ Redistributable installed
    ) else (
        echo ERROR: Failed to download VC Redistributable
        echo Please download manually from:
        echo https://aka.ms/vs/17/release/vc_redist.x64.exe
        pause
    )
) else (
    echo ✓ Visual C++ Redistributable found
)

REM ========================================
REM Install Python Packages
REM ========================================
echo.
echo [3/4] Installing Python Packages...
echo ==========================================

echo Installing PySide6...
pip install PySide6==6.9.1
if errorlevel 1 (
    echo WARNING: PySide6 installation may have failed
)

echo Installing VTK...
pip install vtk==9.5.0
if errorlevel 1 (
    echo WARNING: VTK installation may have failed
)

echo Installing numpy, scipy, matplotlib...
pip install numpy scipy matplotlib
if errorlevel 1 (
    echo WARNING: Some packages may have failed to install
)

echo.
echo ✓ Python packages installed

REM ========================================
REM Verify Installation
REM ========================================
echo.
echo [4/4] Verifying Installation...
echo ==========================================

echo Checking PySide6...
python -c "import PySide6; print('  ✓ PySide6 version:', PySide6.__version__)" 2>nul
if errorlevel 1 echo   ✗ PySide6 not available

echo Checking VTK...
python -c "import vtk; print('  ✓ VTK version:', vtk.VTK_VERSION)" 2>nul
if errorlevel 1 echo   ✗ VTK not available

echo Checking numpy...
python -c "import numpy; print('  ✓ numpy version:', numpy.__version__)" 2>nul
if errorlevel 1 echo   ✗ numpy not available

echo Checking scipy...
python -c "import scipy; print('  ✓ scipy version:', scipy.__version__)" 2>nul
if errorlevel 1 echo   ✗ scipy not available

echo Checking matplotlib...
python -c "import matplotlib; print('  ✓ matplotlib version:', matplotlib.__version__)" 2>nul
if errorlevel 1 echo   ✗ matplotlib not available

REM ========================================
REM Complete
REM ========================================
echo.
echo ==========================================
echo Installation Complete!
echo ==========================================
echo.
echo You can now launch RapidSurf with:
echo   launch_rapidsurf.bat
echo.
echo Or directly:
echo   RapidSurf.exe
echo.
pause

endlocal
